package gui;

import java.awt.EventQueue;

import javax.swing.JDialog;
import javax.swing.JPanel;

import java.awt.BorderLayout;

import music.Song;
import net.miginfocom.swing.MigLayout;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import java.awt.FlowLayout;

import javax.swing.JTabbedPane;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class NewDialog extends JDialog {
	private JPanel southPanel;
	private JButton btnOk;
	private JButton btnCancel;
	private JTabbedPane tabbedPane;
	private JPanel songPanel;
	private JPanel authorPanel;
	private JLabel lblSong;
	private JLabel lblYear;
	private JLabel lblLyrics;
	private JTextField titleTextField;
	private JTextField yearTextField;
	private JScrollPane scrollPane;
	private JTextArea lyricsTextArea;
	private Song song;
	private NewDialog thisDialog;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					NewDialog dialog = new NewDialog();
					dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					dialog.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the dialog.
	 */
	public NewDialog(JFrame f, boolean modal) {
		setTitle("New");
		setBounds(100, 100, 450, 300);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		getContentPane().add(getTabbedPane(), BorderLayout.CENTER);
		this.setModal(modal);
		thisDialog = this;
		
	}

	public NewDialog() {
		setTitle("New");
		setBounds(100, 100, 450, 300);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		getContentPane().add(getTabbedPane(), BorderLayout.CENTER);

	}

	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[grow][][]", "[]"));
			southPanel.add(getBtnOk(), "cell 1 0");
			southPanel.add(getBtnCancel(), "cell 2 0");
		}
		return southPanel;
	}
	private JButton getBtnOk() {
		if (btnOk == null) {
			btnOk = new JButton("OK");
			btnOk.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					song = new Song();
					
					thisDialog.setVisible(false);
				}
			});
		}
		return btnOk;
	}
	private JButton getBtnCancel() {
		if (btnCancel == null) {
			btnCancel = new JButton("Cancel");
			btnCancel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					song = null;
					thisDialog.setVisible(false);
				}
			});
		}
		return btnCancel;
	}
	private JTabbedPane getTabbedPane() {
		if (tabbedPane == null) {
			tabbedPane = new JTabbedPane(JTabbedPane.TOP);
			tabbedPane.addTab("Song", null, getSongPanel(), null);
			tabbedPane.addTab("Author", null, getAuthorPanel(), null);
		}
		return tabbedPane;
	}
	private JPanel getSongPanel() {
		if (songPanel == null) {
			songPanel = new JPanel();
			songPanel.setLayout(new MigLayout("", "[][grow]", "[][][][grow]"));
			songPanel.add(getLblSong(), "cell 0 0,alignx trailing");
			songPanel.add(getTitleTextField(), "cell 1 0,growx");
			songPanel.add(getLblYear(), "cell 0 1,alignx trailing");
			songPanel.add(getTextField_1(), "cell 1 1,growx");
			songPanel.add(getLblLyrics(), "cell 0 2");
			songPanel.add(getScrollPane(), "cell 0 3 2 1,grow");
		}
		return songPanel;
	}
	private JPanel getAuthorPanel() {
		if (authorPanel == null) {
			authorPanel = new JPanel();
		}
		return authorPanel;
	}
	private JLabel getLblSong() {
		if (lblSong == null) {
			lblSong = new JLabel("Title");
		}
		return lblSong;
	}
	private JLabel getLblYear() {
		if (lblYear == null) {
			lblYear = new JLabel("Year");
		}
		return lblYear;
	}
	private JLabel getLblLyrics() {
		if (lblLyrics == null) {
			lblLyrics = new JLabel("Lyrics");
		}
		return lblLyrics;
	}
	private JTextField getTitleTextField() {
		if (titleTextField == null) {
			titleTextField = new JTextField();
			titleTextField.setColumns(10);
		}
		return titleTextField;
	}
	private JTextField getTextField_1() {
		if (yearTextField == null) {
			yearTextField = new JTextField();
			yearTextField.setColumns(10);
		}
		return yearTextField;
	}
	private JScrollPane getScrollPane() {
		if (scrollPane == null) {
			scrollPane = new JScrollPane();
			scrollPane.setViewportView(getLyricsTextArea());
		}
		return scrollPane;
	}
	private JTextArea getLyricsTextArea() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
		}
		return lyricsTextArea;
	}
	
	public Song showDialog() {
		this.setVisible(true);
		dispose();
		return song;
	}
}
